import java.io.*;


abstract class LocalClassLoader extends ClassLoader {

    private String directory; 

    public LocalClassLoader (String dir) {
	directory = dir;
    }

    protected Class loadClassFromFile(String name) 
	throws ClassNotFoundException, FileNotFoundException {
	File target = new File(directory + name.replace('.', '/') + ".class");
	if (! target.exists()) throw new FileNotFoundException();
	long bytecount = target.length();
	byte [] buffer = new byte[(int) bytecount];
	try {
	    FileInputStream f = new FileInputStream(target);
	    int readCount = f.read(buffer);
	    f.close();
	    Class c = defineClass(name, buffer, 0, (int) bytecount);
	    System.out.println
		("[Loaded " + name + " from " + target + " ("+ bytecount + " bytes)]");
	    return c;
	}
	catch (Exception e) {
	    System.out.println("Aborting read: " + e.toString() +
                               " in LocalClassLoader.");
	    throw new ClassNotFoundException();
	};
    }
}


class DelegatingLoader extends LocalClassLoader {

    private String[] undelegatedNames;
    
    public DelegatingLoader (String dir, String[] undelNames) {
	super(dir);
	this.undelegatedNames = undelNames;
    }
    
    private boolean isUndelegatedName (String name) {
	boolean found = false;
	for (int i=0; i < undelegatedNames.length && !found; i++)
	    if (undelegatedNames[i].equals(name))  found = true;
	return found;
    }
    
    public Class loadClass(String name) throws ClassNotFoundException {
	try {
	    Class prevLoaded = this.findLoadedClass(name);
	    if (prevLoaded != null)
		return prevLoaded;
	    else if (isUndelegatedName(name))
		return this.loadClassFromFile(name);
	    else {
		System.out.println("[Loaded " + name + " from system]");
		return this.findSystemClass(name);
	    }
	} catch (Exception d) {
	    System.out.println("Exception " + d.toString() +
			       " while loading " + name + " in DelegatingLoader.");
	    throw new ClassNotFoundException();
	}
    }

}


class Starter {
    public static void go (String[] undelNames,
			   String className,
			   String methodName) {
	try {
	    DelegatingLoader loader = new DelegatingLoader("dir/", undelNames);
	    Class c = loader.loadClass(className);
	    Object [] arg = {};
	    Class [] argClass = {};
	    c.getMethod(methodName, argClass).invoke(null, arg);
	} catch (Exception e) {
	    System.out.println("Error " + e.toString() + " in Main.main.");
	    e.printStackTrace();
	}
    }
}
